/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.AEKeyFilter;
import appeng.core.AELog;
import appeng.util.Platform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.jetbrains.annotations.Nullable;

public final class AEItemKey
extends AEKey {
    private static final MethodHandle SERIALIZE_CAPS_HANDLE;
    private final Item item;
    @Nullable
    private final CompoundTag tag;
    @Nullable
    private final CompoundTag caps;
    private final int hashCode;

    @Nullable
    private static CompoundTag serializeStackCaps(ItemStack stack) {
        try {
            CompoundTag caps = SERIALIZE_CAPS_HANDLE.invokeExact((CapabilityProvider)stack);
            return caps == null || caps.m_128456_() ? null : caps;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to call serializeCaps", ex);
        }
    }

    private AEItemKey(Item item, @Nullable CompoundTag tag, @Nullable CompoundTag caps) {
        super(Platform.getItemDisplayName(item, tag));
        this.item = item;
        this.tag = tag;
        this.caps = caps;
        this.hashCode = Objects.hash(item, tag, caps);
    }

    @Nullable
    public static AEItemKey of(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        return AEItemKey.of((ItemLike)stack.m_41720_(), stack.m_41783_(), AEItemKey.serializeStackCaps(stack));
    }

    public static boolean matches(AEKey what, ItemStack itemStack) {
        AEItemKey itemKey;
        return what instanceof AEItemKey && (itemKey = (AEItemKey)what).matches(itemStack);
    }

    public static boolean is(AEKey what) {
        return what instanceof AEItemKey;
    }

    public static AEKeyFilter filter() {
        return AEItemKey::is;
    }

    @Override
    public AEKeyType getType() {
        return AEKeyType.items();
    }

    @Override
    public AEItemKey dropSecondary() {
        return AEItemKey.of((ItemLike)this.item, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AEItemKey aeItemKey = (AEItemKey)o;
        return this.hashCode == aeItemKey.hashCode && this.item == aeItemKey.item && Objects.equals(this.tag, aeItemKey.tag) && Objects.equals(this.caps, aeItemKey.caps);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static AEItemKey of(ItemLike item) {
        return AEItemKey.of(item, null);
    }

    public static AEItemKey of(ItemLike item, @Nullable CompoundTag tag) {
        return AEItemKey.of(item, tag, null);
    }

    private static AEItemKey of(ItemLike item, @Nullable CompoundTag tag, @Nullable CompoundTag caps) {
        return new AEItemKey(item.m_5456_(), tag != null ? tag.m_6426_() : null, caps);
    }

    public boolean matches(ItemStack stack) {
        return !stack.m_41619_() && stack.m_150930_(this.item) && Objects.equals(stack.m_41783_(), this.tag) && Objects.equals(this.caps, AEItemKey.serializeStackCaps(stack));
    }

    public ItemStack toStack() {
        return this.toStack(1);
    }

    public ItemStack toStack(int count) {
        if (count <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)this.item, count, this.caps);
        result.m_41751_(this.copyTag());
        return result;
    }

    public Item getItem() {
        return this.item;
    }

    @Nullable
    public static AEItemKey fromTag(CompoundTag tag) {
        try {
            Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(tag.m_128461_("id"))).orElseThrow(() -> new IllegalArgumentException("Unknown item id."));
            CompoundTag extraTag = tag.m_128441_("tag") ? tag.m_128469_("tag") : null;
            CompoundTag extraCaps = tag.m_128441_("caps") ? tag.m_128469_("caps") : null;
            return AEItemKey.of((ItemLike)item, extraTag, extraCaps);
        }
        catch (Exception e) {
            AELog.debug("Tried to load an invalid item key from NBT: %s", tag, e);
            return null;
        }
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag result = new CompoundTag();
        result.m_128359_("id", Registry.f_122827_.m_7981_((Object)this.item).toString());
        if (this.tag != null) {
            result.m_128365_("tag", (Tag)this.tag.m_6426_());
        }
        if (this.caps != null) {
            result.m_128365_("caps", (Tag)this.caps.m_6426_());
        }
        return result;
    }

    @Override
    public Object getPrimaryKey() {
        return this.item;
    }

    @Override
    public int getFuzzySearchValue() {
        return this.tag == null ? 0 : this.tag.m_128451_("Damage");
    }

    @Override
    public int getFuzzySearchMaxValue() {
        return this.item.m_41462_();
    }

    @Override
    public ResourceLocation getId() {
        return Registry.f_122827_.m_7981_((Object)this.item);
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    @Nullable
    public CompoundTag copyTag() {
        return this.tag != null ? this.tag.m_6426_() : null;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public ItemStack wrapForDisplayOrFilter() {
        return this.toStack();
    }

    @Override
    public ItemStack wrap(int amount) {
        return this.toStack(amount);
    }

    @Override
    public void addDrops(long amount, List<ItemStack> drops, Level level, BlockPos pos) {
        while (amount > 0L) {
            if (drops.size() > 1000) {
                AELog.warn("Tried dropping an excessive amount of items, ignoring %s %ss", amount, this.item);
                break;
            }
            long taken = Math.min(amount, (long)this.item.m_41459_());
            amount -= taken;
            drops.add(this.toStack((int)taken));
        }
    }

    @Override
    public boolean isTagged(TagKey<?> tag) {
        return this.item.m_204114_().m_203656_(tag);
    }

    public boolean isDamaged() {
        return this.tag != null && this.tag.m_128451_("Damage") > 0;
    }

    @Override
    public void writeToPacket(FriendlyByteBuf data) {
        data.m_130130_(Item.m_41393_((Item)this.item));
        CompoundTag compoundTag = null;
        if (this.item.m_41465_() || this.item.m_41468_()) {
            compoundTag = this.item.getShareTag(this.toStack());
        }
        data.m_130079_(compoundTag);
    }

    public static AEItemKey fromPacket(FriendlyByteBuf data) {
        int i = data.m_130242_();
        Item item = Item.m_41445_((int)i);
        CompoundTag shareTag = data.m_130260_();
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.readShareTag(shareTag);
        return new AEItemKey(item, stack.m_41783_(), AEItemKey.serializeStackCaps(stack));
    }

    public String toString() {
        ResourceLocation id = Registry.f_122827_.m_7981_((Object)this.item);
        String idString = id != Registry.f_122827_.m_122315_() ? id.toString() : this.item.getClass().getName() + "(unregistered)";
        return this.tag == null ? idString : idString + " (+tag)";
    }

    static {
        try {
            Method method = CapabilityProvider.class.getDeclaredMethod("serializeCaps", new Class[0]);
            method.setAccessible(true);
            SERIALIZE_CAPS_HANDLE = MethodHandles.lookup().unreflect(method);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create serializeCaps method handle", exception);
        }
    }
}

